%{

This example shows how to read a time-temperature profile from a CSV-file and running a precipitation calculation
with it. The easiest CSV-file is simply a comma-separated text-file as shown in the present example.

%}

dependent_element = "Al";
compositions = containers.Map({'Sc'}, {0.18});%Mass percent
elements_solutes = string(compositions.keys());
elements = [dependent_element elements_solutes];
thermo_database = "ALDEMO";
kinetic_database = "MALDEMO";

% session = TCToolbox();
session = tc_toolbox.TCToolbox();
[filepath,name,ext] = fileparts(mfilename('fullpath'));
session.set_cache_folder( name + "_cache");

[time_temp_profile, last_time_temp_profile_time] = get_time_temp_profile("time_temperature.txt");

sys = session.select_thermodynamic_and_kinetic_databases_with_elements(thermo_database, kinetic_database, elements)...
                     .get_system();

calculation = sys.with_non_isothermal_precipitation_calculation();
calculation.set_composition_unit(tc_toolbox.CompositionUnit.MASS_PERCENT);
calculation.with_temperature_profile(time_temp_profile);
calculation.set_simulation_time(last_time_temp_profile_time);
calculation.with_matrix_phase(tc_toolbox.precipitation.MatrixPhase("FCC_A1")...
    .add_precipitate_phase(tc_toolbox.precipitation.PrecipitatePhase("AL3SC"))...
    );
                       
for element_key = compositions.keys()
    element = element_key{1};
    calculation.set_composition(element, compositions(element));
end               


simulation_results = calculation.calculate();
[time, mean_radius] = simulation_results.get_mean_radius_of("AL3SC");

plot(time, mean_radius)
title("Al3Sc precipitation")
xlabel("Time [s]")
ylabel("Mean radius [m]")

    
% reading the CSV-file and converting it to the TC-Python datastructure
function  [temperature_profile, last_time_temp_profile_time] = get_time_temp_profile(file)
    table = readtable(file);
    temperature_profile = tc_toolbox.TemperatureProfile();
    for row_index = 1:length(table.time_s) 
        temperature_profile.add_time_temperature(table.time_s(row_index), table.temperature_K(row_index));
    end   
    last_time_temp_profile_time = table.time_s(end);
end
